<?php

namespace Config;

use CodeIgniter\Config\BaseConfig;
use CodeIgniter\Filters\CSRF;
use CodeIgniter\Filters\DebugToolbar;
use CodeIgniter\Filters\Honeypot;
use CodeIgniter\Filters\InvalidChars;
use CodeIgniter\Filters\SecureHeaders;

class Filters extends BaseConfig
{
    /**
     * Configures aliases for Filter classes to
     * make reading things nicer and simpler.
     */
    public array $aliases = [
        'csrf'          => CSRF::class,
        'toolbar'       => DebugToolbar::class,
        'honeypot'      => Honeypot::class,
        'invalidchars'  => InvalidChars::class,
        'secureheaders' => SecureHeaders::class,
        'auth'          => \App\Filters\AuthFilter::class,  // ✅ Filtro de autenticación
    ];

    /**
     * List of filter aliases that are always
     * applied before and after every request.
     */
    public array $globals = [
        'before' => [
            // 'honeypot',
            // 'csrf',
            // 'invalidchars',
        ],
        'after' => [
            'toolbar',
            // 'honeypot',
            // 'secureheaders',
        ],
    ];

    /**
     * List of filter aliases that works on a
     * particular HTTP method (GET, POST, etc.).
     */
    public array $methods = [];

    /**
     * List of filter aliases that should run on any
     * before or after URI patterns.
     */
    public array $filters = [
        'auth' => [
            'before' => [
                // ========== PERFIL ==========
                'api/perfil',                    // ✅ GET/PUT /api/perfil
                'api/perfil/*',
                'api/cambiar-password',          // ✅ PUT /api/cambiar-password
                'api/cuenta',                    // ✅ DELETE /api/cuenta
                
                // ========== ESTUDIANTES ==========
                'api/estudiantes',               // ✅ GET/POST /api/estudiantes
                'api/estudiantes/*',             // ✅ GET/PUT/DELETE /api/estudiantes/{id}
                
                // ========== ASISTENCIAS ==========
                'api/asistencias',               // ✅ GET/POST /api/asistencias
                'api/asistencias/*',             // ✅ GET/PUT/DELETE /api/asistencias/{id}
                
                // ========== MATERIAS ==========
                'api/materias',                  // ✅ GET/POST /api/materias
                'api/materias/*',                // ✅ GET/PUT/DELETE /api/materias/{id}
                
                // ========== ALUMNOS (si usas esta ruta) ==========
                'api/alumnos',
                'api/alumnos/*',
            ]
        ]
    ];
}
