<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width,initial-scale=1" />
  <meta name="description" content="Panel administrativo moderno - Sistema de Gestión de Estudiantes (2025)" />
  <title>Dashboard · Sistema de Gestión de Estudiantes</title>

  <!-- Google Font: Inter (variable) -->
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700;800&display=swap" rel="stylesheet">

  <link rel="icon" href="/favicon.ico" />

  <style>
    :root{
      --bg: #0f172a; /* used for dark default background for contrast fallback */
      --surface: #ffffff;
      --muted: #64748b;
      --primary: #2563eb;
      --accent: #06b6d4;
      --success: #10b981;
      --danger: #ef4444;
      --glass: rgba(255,255,255,0.06);
      --card-shadow: 0 6px 18px rgba(16,24,40,0.06);
      --radius: 12px;
      color-scheme: light dark;
      font-family: 'Inter', system-ui, -apple-system, 'Segoe UI', Roboto, 'Helvetica Neue', Arial;
    }

    /* light theme overrides */
    .theme-light{ --bg: #f8fafc; --surface: #ffffff; --muted: #64748b; --glass: rgba(15,23,42,0.03); }
    .theme-dark { --bg: #0b1220; --surface: #0f1724; --muted: #9aa6bf; --glass: rgba(255,255,255,0.03); }

    *{ box-sizing: border-box; }
    html,body{ height:100%; }
    body{
      margin:0; min-height:100%; background:var(--bg); color:var(--muted); -webkit-font-smoothing:antialiased; -moz-osx-font-smoothing:grayscale;
      padding:0; font-size:15px; line-height:1.45; transition: background .2s ease, color .2s ease;
    }

    /* Layout */
    .app{
      max-width:1320px; margin:28px auto; padding:20px; display:grid; gap:20px;
      grid-template-columns: 1fr; align-items:start;
    }

    header.topbar{
      display:flex; align-items:center; justify-content:space-between; gap:12px; background: linear-gradient(90deg, rgba(255,255,255,0.02), transparent);
      padding:12px 16px; border-radius:14px; box-shadow:var(--card-shadow); border:1px solid var(--glass);
    }

    .brand{ display:flex; gap:12px; align-items:center; }
    .brand .logo{
      width:48px; height:48px; border-radius:10px; display:grid; place-items:center; font-weight:800; color:white;
      background:linear-gradient(135deg,var(--primary),var(--accent)); font-size:18px;
    }
    .brand .title{ font-weight:700; color:var(--surface); font-size:1.05rem; }
    .brand .subtitle{ font-size:0.82rem; color:var(--muted); margin-top:2px }

    /* controls */
    .controls{ display:flex; gap:8px; align-items:center }
    .search{ position:relative; }
    .search input{ padding:10px 12px 10px 36px; border-radius:10px; border:1px solid var(--glass); background:transparent; color:var(--surface); outline:none; min-width:220px }
    .search svg{ position:absolute; left:10px; top:50%; transform:translateY(-50%); opacity:0.8 }

    .chip{ display:inline-flex; gap:8px; align-items:center; padding:8px 10px; border-radius:999px; background:var(--glass); color:var(--surface); border:1px solid rgba(255,255,255,0.03); font-weight:600 }

    .actions{ display:flex; gap:8px; align-items:center }
    .btn{ background:linear-gradient(90deg,var(--primary),var(--accent)); color:white; border:none; padding:10px 12px; border-radius:10px; cursor:pointer; font-weight:600 }
    .ghost{ background:transparent; border:1px solid var(--glass); padding:8px 10px; border-radius:10px; color:var(--surface); cursor:pointer }

    /* Grid: welcome + cards */
    .welcome{ display:grid; grid-template-columns: 1fr auto; gap:18px; align-items:center; padding:20px; border-radius:14px; background:linear-gradient(135deg,var(--primary),var(--accent)); color:white; box-shadow:var(--card-shadow); }
    .welcome h1{ margin:0; font-size:1.45rem; font-weight:800 }
    .welcome p{ margin:6px 0 0; opacity:0.95 }

    .grid{
      display:grid; gap:18px; grid-template-columns: repeat(4,1fr);
    }

    @media (max-width:1100px){ .grid{ grid-template-columns: repeat(2,1fr); } }
    @media (max-width:640px){ .grid{ grid-template-columns: 1fr; } .search input{ min-width:120px } .app{ padding:12px } }

    .card{ background:var(--surface); color:var(--bg); padding:16px; border-radius:12px; box-shadow:var(--card-shadow); border:1px solid var(--glass) }
    .card .card-head{ display:flex; justify-content:space-between; align-items:center; gap:8px; margin-bottom:10px }
    .card .label{ font-weight:700; color:var(--muted); font-size:0.9rem }
    .big{ font-size:1.6rem; font-weight:800; color:var(--bg) }

    /* stat small */
    .stat{ display:flex; gap:12px; align-items:center }
    .stat .icon{ width:48px; height:48px; border-radius:10px; display:grid; place-items:center; background:linear-gradient(180deg, rgba(255,255,255,0.08), transparent); color:var(--primary); font-size:20px }

    /* activity list */
    .activity{ display:flex; flex-direction:column; gap:10px }
    .activity .item{ display:flex; gap:12px; align-items:flex-start }
    .activity .item .dot{ width:44px; height:44px; border-radius:10px; display:grid; place-items:center; background:var(--glass); color:var(--surface) }
    .activity .meta{ font-size:0.9rem; color:var(--muted) }

    /* quick actions grid */
    .quick{ display:grid; gap:10px; grid-template-columns:repeat(2,1fr) }
    @media (max-width:480px){ .quick{ grid-template-columns:1fr } }
    .action{ display:flex; align-items:center; gap:10px; padding:12px; border-radius:10px; background:linear-gradient(90deg, rgba(37,99,235,0.08), rgba(6,182,212,0.06)); border:1px solid var(--glass); cursor:pointer }

    footer{ text-align:center; color:var(--muted); margin-top:8px; font-size:0.9rem }

    /* small helpers */
    .muted{ color:var(--muted) }
    a { color:inherit; text-decoration:none }

  </style>
</head>
<body class="theme-light">

  <div class="app">

    <header class="topbar" role="banner">
      <div class="brand">
        <div class="logo">SG</div>
        <div>
          <div class="title">Sistema de Gestión · IPAT</div>
          <div class="subtitle">Panel administrativo — 2025</div>
        </div>
      </div>

      <div class="controls" role="navigation" aria-label="Controles principales">
        <div class="search" aria-hidden="false">
          <svg width="16" height="16" viewBox="0 0 24 24" fill="none" aria-hidden="true"><path d="M21 21l-4.35-4.35" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><circle cx="11" cy="11" r="6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>
          <input type="search" id="q" placeholder="Buscar estudiantes, materias..." aria-label="Buscar" />
        </div>

        <button class="ghost" id="themeToggle" title="Cambiar tema">🌗</button>
        <div class="chip" aria-hidden="true">Admin</div>
        <button class="btn" onclick="location.href='#'">Nuevo</button>
      </div>
    </header>

    <!-- Welcome -->
    <section class="welcome" aria-labelledby="welcomeTitle">
      <div>
        <h1 id="welcomeTitle">Bienvenido de nuevo, Administrador</h1>
        <p>Gestiona estudiantes, materias y asistencias con un flujo más rápido y accesible.</p>
        <p style="margin-top:8px; opacity:0.9">Última sincronización: <strong class="muted"><?php echo date('d/m/Y H:i'); ?></strong></p>
      </div>

      <div style="display:flex; flex-direction:column; gap:8px; align-items:flex-end;">
        <div style="text-align:right">
          <div class="muted">Estado del sistema</div>
          <div style="font-weight:800; font-size:1.1rem; color:var(--surface)"><?php echo !empty($system_status) ? esc($system_status) : 'Operativo'; ?></div>
        </div>

        <div style="display:flex; gap:8px">
          <div class="chip">⏱️ Tiempo real</div>
          <div class="chip">🔒 Seguro</div>
        </div>
      </div>
    </section>

    <!-- Quick stats -->
    <section class="grid" aria-label="Estadísticas rápidas">

      <div class="card" role="region" aria-label="Estudiantes registrados">
        <div class="card-head">
          <div class="label">Estudiantes Registrados</div>
          <div class="muted">Total</div>
        </div>
        <div style="display:flex; justify-content:space-between; align-items:center;">
          <div>
            <div class="big"><?php echo !empty($total_estudiantes) ? $total_estudiantes : '11'; ?></div>
            <div class="muted">Activos en el periodo</div>
          </div>
          <div class="stat">
            <div class="icon">👨‍🎓</div>
          </div>
        </div>
      </div>

      <div class="card" role="region" aria-label="Materias activas">
        <div class="card-head">
          <div class="label">Materias Activas</div>
          <div class="muted">Asignadas</div>
        </div>
        <div style="display:flex; justify-content:space-between; align-items:center;">
          <div>
            <div class="big"><?php echo !empty($total_materias) ? $total_materias : '3'; ?></div>
            <div class="muted">Materias en el semestre</div>
          </div>
          <div class="stat"><div class="icon">📚</div></div>
        </div>
      </div>

      <div class="card" role="region" aria-label="Asistencias hoy">
        <div class="card-head">
          <div class="label">Asistencias Hoy</div>
          <div class="muted">Registros</div>
        </div>
        <div style="display:flex; justify-content:space-between; align-items:center;">
          <div>
            <div class="big"><?php echo !empty($total_asistencias) ? $total_asistencias : '4'; ?></div>
            <div class="muted">Última hora</div>
          </div>
          <div class="stat"><div class="icon">✓</div></div>
        </div>
      </div>

      <div class="card" role="region" aria-label="Usuarios activos">
        <div class="card-head">
          <div class="label">Usuarios Activos</div>
          <div class="muted">Sesiones</div>
        </div>
        <div style="display:flex; justify-content:space-between; align-items:center;">
          <div>
            <div class="big"><?php echo !empty($total_usuarios) ? $total_usuarios : '7'; ?></div>
            <div class="muted">Con sesión iniciada</div>
          </div>
          <div class="stat"><div class="icon">👥</div></div>
        </div>
      </div>

    </section>

    <!-- Activities + Actions -->
    <section style="display:grid; gap:18px; grid-template-columns: 1fr 380px;">

      <div class="card" aria-label="Actividad reciente">
        <div class="card-head">
          <div class="label">Actividad Reciente</div>
          <div class="muted">Últimas 24 horas</div>
        </div>

        <div class="activity">
          <?php if (!empty($actividades_recientes) && is_array($actividades_recientes)): ?>
            <?php foreach(array_slice($actividades_recientes,0,8) as $act): ?>
              <div class="item">
                <div class="dot <?= esc($act['tipo']) ?>"><?= esc($act['icono']) ?></div>
                <div>
                  <div style="font-weight:700; color:var(--bg)"><?= esc($act['titulo']) ?></div>
                  <div class="meta"><?= esc($act['descripcion']) ?> · <span class="muted"><?= esc($act['fecha']) ?></span></div>
                </div>
              </div>
            <?php endforeach; ?>
          <?php else: ?>
            <!-- ejemplo estático -->
            <div class="item"><div class="dot">➕</div><div><div style="font-weight:700; color:var(--bg)">Nuevo estudiante registrado</div><div class="meta">Jose Mamani · <span class="muted">Hace 1 día</span></div></div></div>
            <div class="item"><div class="dot">✓</div><div><div style="font-weight:700; color:var(--bg)">Asistencia registrada</div><div class="meta">Luis M. Sánchez - Inglés · <span class="muted">Hace 2 horas</span></div></div></div>
            <div class="item"><div class="dot">📚</div><div><div style="font-weight:700; color:var(--bg)">Nueva materia creada</div><div class="meta">Inglés - 1ro C · <span class="muted">Hace 2 días</span></div></div></div>
          <?php endif; ?>
        </div>
      </div>

      <aside style="display:flex; flex-direction:column; gap:12px;">
        <div class="card">
          <div class="card-head"><div class="label">Acciones Rápidas</div><div class="muted">Atajos</div></div>
          <div class="quick">
            <button class="action" onclick="location.href='#'">➕ Agregar Estudiante</button>
            <button class="action" onclick="location.href='#'">📚 Nueva Materia</button>
            <button class="action" onclick="location.href='#'">✓ Registrar Asistencia</button>
            <button class="action" onclick="location.href='#'">📊 Ver Reportes</button>
          </div>
        </div>

        <div class="card">
          <div class="card-head"><div class="label">Resumen de Asistencias</div><div class="muted">Hoy</div></div>
          <div style="display:flex; flex-direction:column; gap:8px">
            <div style="display:flex; justify-content:space-between"><div>Presentes</div><div class="muted"><?php echo !empty($asistencias_presente) ? $asistencias_presente : '1'; ?> estudiantes</div></div>
            <div style="display:flex; justify-content:space-between"><div>Tardanzas</div><div class="muted"><?php echo !empty($asistencias_tardanza) ? $asistencias_tardanza : '3'; ?> estudiantes</div></div>
            <div style="display:flex; justify-content:space-between"><div>Ausentes</div><div class="muted"><?php echo !empty($asistencias_ausente) ? $asistencias_ausente : '0'; ?> estudiantes</div></div>
          </div>
        </div>

      </aside>

    </section>

    <footer>
      &copy; <?php echo date('Y'); ?> Sistema de Gestión de Estudiantes · Desarrollado con CodeIgniter · <span class="muted">Tacna, Perú</span>
    </footer>

  </div>

  <script>
    // tema (persistente) y mejora de accesibilidad
    const root = document.documentElement;
    const body = document.body;
    const btn = document.getElementById('themeToggle');
    const saved = localStorage.getItem('theme') || 'light';
    setTheme(saved);

    function setTheme(name){
      if(name === 'dark'){
        body.classList.remove('theme-light'); body.classList.add('theme-dark');
      } else { body.classList.remove('theme-dark'); body.classList.add('theme-light'); }
      localStorage.setItem('theme', name);
      btn.textContent = name === 'dark' ? '🌞' : '🌗';
    }

    btn.addEventListener('click', ()=>{
      const current = body.classList.contains('theme-dark') ? 'dark' : 'light';
      setTheme(current === 'dark' ? 'light' : 'dark');
    });

    // simple keyboard focus for search
    document.getElementById('q').addEventListener('keydown', (e)=>{
      if(e.key === 'Enter'){
        // implement search handler server side
        // example: location.href = '/buscar?q='+encodeURIComponent(e.target.value)
        console.log('Buscar:', e.target.value);
      }
    });
  </script>
</body>
</html>
